<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Waterfall Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array( 
        array("label" => "Sales",  "y" => 1143 ),
        array("label" => "Service", "y" => 500 ),
        array("label" => "Total Revenue", "isIntermediateSum" => true),
        array("label" => "Research", "y" => -200 ),
        array("label" => "Marketing",  "y" => -226 ),
        array("label" => "Salaries", "y" => -559 ),
        array("label" => "Operating Income", "isCumulativeSum" => true ),
        array("label" => "Taxes",  "y" => -300 ),
        array("label" => "Net Income",  "isCumulativeSum" => true )
    );
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            title: {
                text: "Company Finance"
            },
            axisY: {
                title: "Amount (in USD)",
                prefix: "$",
                suffix: "k",
                gridThickness: 0
            },
            data: [{
                type: "waterfall",
                risingColor: "#428CFF",
                fallingColor: "#FF8C8C",
                indexLabel: "{y}",
                indexLabelFontColor: "#292B2C",
                indexLabelFontWeight: "bolder",
                indexLabelPlacement: "inside",
                yValueFormatString: "$#,##0k",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>